function PolyFit_Inspector(pdata)

figure(1)
subplot(1,1,1)
NumPoints = numel(pdata.Xdata);
deg = input(['Degree to fit (any integer between 0 and ',...
       num2str(NumPoints-1),') or -1 to quit: ']);
while(deg>=0 & deg<=NumPoints-1)
  seed = pdata.Seed;
  plotcol = 'k*';
  cv = '';
  [P,S] = polyfit(pdata.Xdata,pdata.Ydata,deg);
  disp(['Degree: ',num2str(deg)]);
  loglike = NumPoints*log(1/(pdata.NoiseLevel*sqrt(2*pi))) ...
            - 1/(2*pdata.NoiseLevel^2)*(S.normr^2);
  disp(['Sum of Penalties: ',num2str(S.normr^2)]);
  % disp(['Likelihood (with NoiseLevel known): ',num2str(exp(loglike))]);
  disp(['Log-Likelihood (with NoiseLevel known): ',num2str(loglike)]);
  disp(['Akaike Information Criterion: ',num2str(2*(deg+1) - 2*loglike)]);
  disp(['Bayesian Information Criterion: ',num2str((deg+1)*log(NumPoints) ...
                                                   - 2*loglike)]);
  while(seed>=0)
    randn('state',seed);
    rand('state',seed)
    NewXdata = rand(1,NumPoints);
    NewYdata = polyval(pdata.Polynomial,NewXdata) ...
                  + pdata.NoiseLevel*randn(1,NumPoints);
    hold off
    plot(NewXdata,NewYdata,plotcol);
    H = title(['Best Fit, Degree = ',num2str(deg),cv]);
    set(H,'FontSize',14);
    hold on
    H = plot(0:.001:1,polyval(P,0:.001:1),'r');
    set(H,'LineWidth',2);
    axis([0,1,0,1])
    seed = input(['New random seed for Cross-Validation (',...
                  num2str(pdata.Seed),...
                 ' original), or -1 for new degree: ']);
    if seed == pdata.Seed
      plotcol = 'k*';
      cv = '';
    else
      plotcol = 'g*';
      cv = [', Cross validated with seed = ',num2str(seed)];
    end
  end
  deg = input(['Degree to fit (any integer between 0 and ',...
       num2str(NumPoints-1),') or -1 to quit: ']);
end
