function key = HH

% PREFIX TO START FILE NAMES
key.prefix = 'HH';

% TEMPLATES TO CONVERT TO FAST RUNNING CODE 
key.steptemplate = 'HH_step_template.m';
key.meastemplate = 'HH_meas_template.m';

% PARAMETERS FOR GENERATING DATA
key.gen.gNa = 120;
key.gen.gK  = 36;
key.gen.gL  = 0.3;
key.gen.ENa = 115;   % mV
key.gen.EK  = -12;   % mV
key.gen.EL  = 10.6;  % mV
key.gen.CAP = 1;     % uF/cm^2
key.gen.PNoiseLevel = 0.01; 
key.gen.MNoiseLevel = 0.001;  

% INITIAL CONDITIONS FOR STATE VARIABLES
key.state.stateV = 0;
key.state.stateM = 0.05293421762087;
key.state.stateN = 0.31768116757978;
key.state.stateH = 0.59611104634676;

% WHICH PARAMETERS TO FIT
key.fit = {'gNa','gK'};

% ASSUMPTIONS ABOUT PARAMETERS & STATES, IF NOT SPECIFIED ASSUMED CORRECT
key.assume.gNa = 125;
key.assume.gL = 0.5;
key.assume.stateV = 1;

% INPUT VARIABES AND CODE FOR CREATING INPUT
key.input = {'injectedCurrent'}; 
key.inputcreate = {@StepCurrent}; 
key.inputparams(1).holding = 0;
key.inputparams(1).step = 10;
key.inputparams(1).start = 10;
key.inputparams(1).stop = 25;

% NOISE VARIABLES 
key.noise.process = {'PNoise'};  
key.noise.measurement = {'MNoise'}; 

% MEASUREMENTS
key.meas = {'measuredVoltage'};

% TRAJECTORY TIME PARAMETERS
key.time.oneDT = 0.01;    % msec 
key.time.sqrtDT = 0.1;    % msec^(1/2) 
key.time.TMAX = 30;       % msec
key.time.fitStart = 9;    % msec

% RANDOM SEED
key.seed = 0;

% DEBUGGING
key.debug = {'ionicCurrent','alpha_m','alpha_n','alpha_h', ...
                            'beta_m','beta_n','beta_h'};
